SuperStrict

' Example 2: Rate and Volume Control
' Demonstrates: SetSpeechRate(), SetSpeechVolume()

Framework BRL.StandardIO

Import "-L."
Import "-lBlitzSpeech"
Include "BlitzSpeechH.bmx"

Print "BlitzSpeech - Rate and Volume Example"

Print ""

If InitSpeech() = SP_INIT_SUCCESS Then
    Local phrase:String = "The quick brown fox jumps over a cow pat"
    
    ' Test different speaking rates
    Print "--- RATE CONTROL ---"
    Print "Rate range: -10 (slowest) to +10 (fastest)"
    Print ""
    
    Print "Normal speed (rate: 0)"
    SetSpeechRate(0)
    SpeakText(phrase)
    Delay(3000)
    
    Print "Slow (rate: -5)"
    SetSpeechRate(-5)
    SpeakText(phrase)
    Delay(4000)
    
    Print "Fast (rate: 5)"
    SetSpeechRate(5)
    SpeakText(phrase)
    Delay(2000)
    
    SetSpeechRate(0)
    Print ""
    
    ' Test different volumes
    Print "--- VOLUME CONTROL ---"
    Print "Volume range: 0 (silent) to 100 (max)"
    Print ""
    
    Print "Normal volume (100)"
    SetSpeechVolume(100)
    SpeakText("This is maximum volume")
    Delay(2000)
    
    Print "Medium volume (50)"
    SetSpeechVolume(50)
    SpeakText("This is half volume")
    Delay(2000)
    
    Print "Quiet volume (25)"
    SetSpeechVolume(25)
    SpeakText("This is quiet")
    Delay(2000)
    
    SetSpeechVolume(100)
    Print ""
    
    Print "Cleaning up..."
    CleanupSpeech()
    Print "Done!"
Else
    Print "Failed to initialize speech!"
EndIf
